function redirectToRegram() {
    const segments = window.location.pathname.split("/").filter(Boolean);
    const params = new URLSearchParams(window.location.search);
    if ((segments.length === 0 && params.has('u')) || segments[0] === 'linkshim') {
        // skip for IG external link redirection (ex: https://l.instagram.com/?u=https%3A%2F%2Fgoogle.com)
    } else {
        window.location.href = `regram://redirect?url=${encodeURIComponent(window.location.href)}`;
    }
}

const element = document.body || document.documentElement;

element.addEventListener('transitionend', function(e) {
    if (e.propertyName === 'width' && e.target.id === 'progress') {
        redirectToRegram();
    }
}, true);

// on page load
redirectToRegram();
